<!DOCTYPE html>
<html lang="en">

<head>
    <title>SmartApps</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="SmartSchool MS is an enterprise on-demand college management solution, designed to solve the difficult challenges facing higher academic institutions. This solution brings improvements to operational efficiency, process transparency, and accountability within the institution." />
    <!-- <meta
      name="keywords"
      content="free bootstrap 4, free bootstrap 4 template, free website templates, free html5, free template, free website template, html5, css3, mobile first, responsive"
    /> -->

    <!-- <link
      href="https://fonts.googleapis.com/css?family=Raleway"
      rel="stylesheet"
    /> -->

    <link href="https://fonts.googleapis.com/css?family=Poppins&display=swap" rel="stylesheet" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" integrity="sha512-Yq3g6bpKo+2xkS1wN6q3JvF8PX3QD9Iy7+5kAhBvV8W5rLoivz16+nbKtRRYvJ8rbMJuvyKXtKLJcQ2/Qvysg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('frontend/css/open-iconic-bootstrap.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('frontend/css/animate.css') }}" />

    <link rel="stylesheet" href="{{ asset('frontend/css/owl.carousel.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('frontend/css/owl.theme.default.min.css') }}" />

    <link rel="stylesheet" href="{{ asset('frontend/css/icomoon.css') }}" />
    <link rel="stylesheet" href="{{ asset('frontend/css/style.css') }}" />

</head>

<body data-spy="scroll" data-target="#ftco-navbar" data-offset="200">
    <nav class="navbar navbar-expand-lg navbar-dark ftco_navbar bg-dark ftco-navbar-light" id="ftco-navbar">
        <div class="container">
            <a class="navbar-brand text-success" href="index.html">SmartSchool</a>
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#ftco-nav" aria-controls="ftco-nav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="oi oi-menu"></span> Menu
            </button>

            <div class="collapse navbar-collapse" id="ftco-nav">
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item active">
                        <a href="#section-home" class="nav-link text-dark">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="#section-features" class="nav-link text-dark">Features</a>
                    </li>
                    <li class="nav-item">
                        <a href="#section-testimonials" class="nav-link text-dark">Testimonials</a>
                    </li>
                    <li class="nav-item">
                        <a href="#section-about" class="nav-link text-dark">About</a>
                    </li>
                    <li class="nav-item">
                        <a href="https://sahrasolutions.com/QampusPlus/admin/login.php?sc=COHZ" class="nav-link text-dark">Demo</a>
                    </li>

                    <!-- <li class="nav-item">
              <button class="btn btn-primary btn-sm navbar-btn" onclick="location.href='https://sahrasolutions.com/QampusPlus/admin/login.php?sc=COHZ'">Request Demo</button>
            </li> -->
                </ul>



            </div>
        </div>
    </nav>
    <!-- END nav -->




    <button onclick="topFunction()" id="myBtn" title="Go to top">
        <i class="fas fa-arrow-up"></i>
    </button>


    <section class="ftco-cover ftco-slant" style="background-image: url({{ asset('frontend/images/recent.jpg') }}); opacity: 0.85" id="section-home">
        <div class="container">
            <div class="row align-items-center justify-content-center text-center ftco-vh-100">
                <div class="col-md-10">
                    <h1 class="ftco-heading ftco-animate">Welcome to SmartSchool MS</h1>
                </div>
            </div>
        </div>
    </section>

    <!-- 
    <section class="ftco-cover ftco-slant" style="background-image: url(images/B1.jpg); opacity: 0.85" id="section-home">
      <div class="container">
        <div class="row align-items-center justify-content-start ftco-vh-100">
          <div class="col-md-6">
            <h1 class="ftco-heading ftco-animate">WELCOME TO OUR WEBSITE</h1>
            <p class="ftco-subheading ftco-animate">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed vestibulum semper nibh, sit amet hendrerit enim mollis vel. Etiam suscipit tristique nulla, in tincidunt velit scelerisque nec. Duis eleifend auctor risus, eu blandit mauris convallis a.</p>
          </div>
        </div>
      </div>
    </section> -->


    <section class="ftco-section bg-light ftco-slant ftco-slant-white" id="section-features">
        <div class="container">
            <div class="row mb-3">
                <div class="col-md-12 text-center mb-5 ftco-animate">
                    <h2 class="text-uppercase ftco-uppercase">Our Features</h2>
                    <hr class="center-line">
                    <div class="row justify-content-center pt-5">
                        <div class="col-md-9">
                            <p class="lead">
                                The application is customizable and very flexible; features
                                can be divided into several modules. Each of the modules is
                                designed to meet the needs of various groups within the
                                institution. The modules include but not limited to the
                                following
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Student Module</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Staff Module</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Bursary Module</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Administration Module</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Library Module</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Human Resources module</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Exams & Records</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Medical Centre</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Hostel management module</h5>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="media d-block mb-4 text-center ftco-media p-md-5 p-4 ftco-animate">
                        <div class="media-body">
                            <h5 class="mt-0">Messaging & Event module</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- END section -->
    <section class="ftco-section ftco-slant ftco-slant-light" id="section-testimonials">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center ftco-animate">
                    <h2 class="text-uppercase ftco-uppercase mb-3">Testimonials</h2>
                    <hr class="center-line" />
                    <div class="row justify-content-center mb-5">
                        <div class="col-md-7"></div>
                    </div>
                </div>
            </div>
            <!-- END row -->
            <div class="row">
                <div class="col-md-12">
                    <div class="owl-carousel ftco-owl">
                        <div class="item ftco-animate border-1">
                            <div class="media d-block text-left ftco-media p-md-2 p-1 border bg-light">
                                <div class="media-body px-2">
                                    <p>
                                        “Having served as a school administrator for several
                                        years, Using SmartSchool has Been able to help us harness
                                        the various aspects of our school administration in such a
                                        wholistic yet simple way. Thesystem can leverage on
                                        registration information to provide a complete cycle for
                                        processing records , reports generation, Information about
                                        students' current academic status/level. This should be
                                        necessary for every institution.”
                                    </p>
                                    <small class="text-center">~ Emmanuel Y. Zakari</small>
                                    <p>
                                        <small>Federal Polytechnic Bida.</small>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="item ftco-animate">
                            <div class="media d-block text-left ftco-media p-md-2 p-1 border bg-light">
                                <div class="media-body px-2">
                                    <p>
                                        “KogiState Polytechnic is able to manage about 8,000
                                        students' records in every session and produce their
                                        results in time and ensure high integrity of records.
                                        Delivering in time and the level of accuracy has been a
                                        huge big before the intervention of SmartSchool”
                                    </p>
                                    <small class="text-center">~ Thomas Alikali</small>
                                    <p>
                                        <small>Kogi State Polytechnic..</small>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="item ftco-animate">
                            <div class="media d-block text-left ftco-media p-md-2 p-1 border bg-light">
                                <div class="media-body px-2">
                                    <p>
                                        “The training has been very simple to accomplish for most
                                        of the end users. Particularly the students and school
                                        administrators.”
                                    </p>
                                    <small class="text-center">~ Usman J. Danladi</small>
                                    <p>
                                        <small>Federal University, Lokoja</small>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="item ftco-animate">
                            <div class="media d-block text-left ftco-media p-md-2 p-1 border bg-light">
                                <div class="media-body px-2">
                                    <p>
                                        “I am very happy with SmartSchool, they were very helpful
                                        when we needed to modify the report to comply with the new
                                        changes. Their customer support are very good listeners
                                        and are dong amazing work. If you are looking for a school
                                        management system that helps you save time and cost, I
                                        highly recommend them”
                                    </p>
                                    <small class="text-center">~ Festus Ubong</small>
                                    <p>
                                        <small>Michael Okpara University of Agriculture</small>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="ftco-section ftco-slant ftco-slant-light bg-light ftco-slant ftco-slant-white" id="section-about">
        <div class="container">
            <div class="row mb-3">
                <div class="col-md-12 ftco-animate">
                    <h2 class="text-uppercase ftco-uppercase">About Us</h2>
                    <hr class="center-line">
                    <div class="row no-gutters align-items-center ftco-animate">
                        <div class="col-md-6 order-md-3 mb-md-0 mb-5 mt-5">
                            <img src="{{ asset('frontend/images/B4.jpg') }}" alt="image" class="img-fluid" />
                        </div>
                        <div class="col-md-6 p-md-5 order-md-1">
                            <p class="lead">
                                SmartSchool MS is an enterprise on-demand college management
                                solution, designed to solve the difficult challenges facing
                                higher academic institutions. This solution brings
                                improvements to operational efficiency, process transparency,
                                and accountability within the institution.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer class="ftco-footer ftco-bg-dark">
        <div class="container">
            <div class="row mb-5">
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md">
                            <div class="ftco-footer-widget mb-4">
                                <h2 class="ftco-heading-2">Company</h2>
                                <ul class="list-unstyled">
                                    <li><a href="#" class="py-2 d-block">About</a></li>
                                    <li><a href="#" class="py-2 d-block">Jobs</a></li>
                                    <li><a href="#" class="py-2 d-block">Press</a></li>
                                    <li><a href="#" class="py-2 d-block">News</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md">
                            <div class="ftco-footer-widget mb-4">
                                <h2 class="ftco-heading-2">Communities</h2>
                                <ul class="list-unstyled">
                                    <li><a href="#" class="py-2 d-block">Support</a></li>
                                    <li>
                                        <a href="#" class="py-2 d-block">Sharing is Caring</a>
                                    </li>
                                    <li><a href="#" class="py-2 d-block">Better Web</a></li>
                                    <li><a href="#" class="py-2 d-block">Good Template</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md">
                            <div class="ftco-footer-widget mb-4">
                                <h2 class="ftco-heading-2">Useful links</h2>
                                <ul class="list-unstyled">
                                    <li><a href="#" class="py-2 d-block">Bootstrap 4</a></li>
                                    <li><a href="#" class="py-2 d-block">jQuery</a></li>
                                    <li><a href="#" class="py-2 d-block">HTML5</a></li>
                                    <li><a href="#" class="py-2 d-block">Sass</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="ftco-footer-widget mb-4">
                        <ul class="ftco-footer-social list-unstyled float-md-right float-lft">
                            <li>
                                <a href="#"><span class="icon-twitter"></span></a>
                            </li>
                            <li>
                                <a href="#"><span class="icon-facebook"></span></a>
                            </li>
                            <li>
                                <a href="#"><span class="icon-instagram"></span></a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md text-left">
                    <p>
                        Festus Ubong
                        <br />
                        Michael Okpara University of Agriculture
                    </p>
                </div>
            </div>
        </div>

        <div class="container-text">
            <div class="ct-footer-copyright" data-id="copyright">
                <p class="footer-text">Copyright &copy; 2023 <a href="https://smartapps.ng/" style="color: purple;"> SmartApps</a>. All rights reserved. </p>
            </div>
        </div>

    </footer>

    <!-- loader -->
    <div id="ftco-loader" class="show fullscreen">
        <svg class="circular" width="48px" height="48px">
            <circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke="#eeeeee" />
            <circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke-miterlimit="10" stroke="#4586ff" />
        </svg>
    </div>

    <script src="{{ asset('frontend/js/jquery.min.js') }}"></script>
    <script src="{{ asset('frontend/js/popper.min.js') }}"></script>
    <script src="{{ asset('frontend/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('frontend/js/jquery.easing.1.3.js') }}"></script>
    <script src="{{ asset('frontend/js/jquery.waypoints.min.js') }}"></script>
    <script src="{{ asset('frontend/js/owl.carousel.min.js') }}"></script>
    <script src="{{ asset('frontend/js/jquery.animateNumber.min.js') }}"></script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBVWaKrjvy3MaE7SQ74_uJiULgl1JY0H2s&sensor=false"></script>
    <script src="{{ asset('frontend/js/google-map.js') }}"></script>

    <script src="{{ asset('frontend/js/main.js') }}"></script>


    <script>
        // When the user scrolls down 20px from the top of the document, show the button
        window.onscroll = function() {
            scrollFunction()
        };

        function scrollFunction() {
            if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
                document.getElementById("myBtn").style.display = "block";
            } else {
                document.getElementById("myBtn").style.display = "none";
            }
        }

        // When the user clicks on the button, scroll to the top of the document
        function topFunction() {
            window.scrollTo({
                top: 0,
                behavior: "smooth"
            });
        }
    </script>
</body>

</html>